VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Sample Program: Trace Data (Transmit Spectrum Mask Check) V1.1"
   ClientHeight    =   8190
   ClientLeft      =   975
   ClientTop       =   1230
   ClientWidth     =   10380
   LinkTopic       =   "Form1"
   ScaleHeight     =   8190
   ScaleWidth      =   10380
   Begin VB.Frame Frame13 
      Caption         =   "Reference Power"
      Height          =   855
      Left            =   7560
      TabIndex        =   31
      Top             =   0
      Width           =   2295
      Begin VB.OptionButton Option2 
         Caption         =   "CH.Power"
         Height          =   255
         Left            =   1080
         TabIndex        =   3
         Top             =   360
         Width           =   1095
      End
      Begin VB.OptionButton Option1 
         Caption         =   "Peak"
         Height          =   255
         Left            =   240
         TabIndex        =   2
         Top             =   360
         Value           =   -1  'True
         Width           =   735
      End
   End
   Begin VB.Frame Frame12 
      Caption         =   "Sweep count for MH/AVG"
      Height          =   975
      Left            =   7560
      TabIndex        =   26
      Top             =   3120
      Width           =   2295
      Begin VB.TextBox TxtAVT 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   240
         TabIndex        =   12
         Text            =   "Text9"
         Top             =   480
         Width           =   1095
      End
      Begin VB.Label Label7 
         Caption         =   "times"
         Height          =   255
         Left            =   1440
         TabIndex        =   30
         Top             =   600
         Width           =   495
      End
   End
   Begin VB.Frame Frame11 
      Caption         =   "Trace calc"
      Height          =   975
      Left            =   7560
      TabIndex        =   25
      Top             =   2040
      Width           =   2295
      Begin VB.ComboBox CmbTRC 
         Height          =   315
         Left            =   240
         TabIndex        =   11
         Text            =   "Combo2"
         Top             =   480
         Width           =   1335
      End
   End
   Begin VB.Frame Frame10 
      Caption         =   "Detector"
      Height          =   975
      Left            =   5160
      TabIndex        =   24
      Top             =   2040
      Width           =   2295
      Begin VB.ComboBox CmbDET 
         Height          =   315
         Left            =   240
         TabIndex        =   10
         Text            =   "Combo1"
         Top             =   480
         Width           =   1455
      End
   End
   Begin VB.Frame Frame9 
      Caption         =   "Video Bandwidth"
      Height          =   975
      Left            =   7560
      TabIndex        =   23
      Top             =   960
      Width           =   2295
      Begin VB.TextBox TxtVB 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   240
         TabIndex        =   7
         Text            =   "Text8"
         Top             =   450
         Width           =   1095
      End
      Begin VB.Label Label5 
         Caption         =   "kHz"
         Height          =   255
         Left            =   1440
         TabIndex        =   28
         Top             =   600
         Width           =   615
      End
   End
   Begin VB.Frame Frame8 
      Caption         =   "Resolution Bandwidth"
      Height          =   975
      Left            =   5160
      TabIndex        =   22
      Top             =   960
      Width           =   2295
      Begin VB.TextBox TxtRB 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   240
         TabIndex        =   6
         Text            =   "Text7"
         Top             =   480
         Width           =   1095
      End
      Begin VB.Label Label4 
         Caption         =   "kHz"
         Height          =   255
         Left            =   1440
         TabIndex        =   27
         Top             =   600
         Width           =   495
      End
   End
   Begin VB.Frame Frame7 
      Caption         =   "Span"
      Height          =   975
      Left            =   2760
      TabIndex        =   21
      Top             =   960
      Width           =   2295
      Begin VB.TextBox TxtSP 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   240
         TabIndex        =   5
         Text            =   "Text6"
         Top             =   480
         Width           =   1095
      End
      Begin VB.Label Label6 
         Caption         =   "MHz"
         Height          =   255
         Left            =   1440
         TabIndex        =   29
         Top             =   600
         Width           =   495
      End
   End
   Begin VB.TextBox Text4 
      Height          =   3615
      Left            =   360
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   13
      Top             =   4320
      Width           =   9615
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00C0FFFF&
      Caption         =   "Start Measurement"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Left            =   1680
      Style           =   1  'Graphical
      TabIndex        =   0
      Top             =   3240
      Width           =   4695
   End
   Begin VB.Frame Frame5 
      Caption         =   "Input attenuator [dB]"
      Height          =   975
      Left            =   2760
      TabIndex        =   18
      Top             =   2040
      Width           =   2295
      Begin VB.ComboBox CmbATT 
         Height          =   315
         Left            =   240
         TabIndex        =   9
         Text            =   "Combo3"
         Top             =   480
         Width           =   1335
      End
   End
   Begin VB.TextBox TxtRL 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   600
      TabIndex        =   8
      Text            =   "Text1"
      Top             =   2520
      Width           =   1095
   End
   Begin VB.Frame Frame4 
      Caption         =   "Refelence level [dBm]"
      Height          =   975
      Left            =   360
      TabIndex        =   17
      Top             =   2040
      Width           =   2295
      Begin VB.Label Label2 
         Caption         =   "dBm"
         Height          =   255
         Left            =   1320
         TabIndex        =   20
         Top             =   600
         Width           =   735
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Center Freqency"
      Height          =   975
      Left            =   360
      TabIndex        =   16
      Top             =   960
      Width           =   2295
      Begin VB.TextBox TxtCF 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   240
         TabIndex        =   4
         Text            =   "Text3"
         Top             =   480
         Width           =   1095
      End
      Begin VB.Label Label1 
         Caption         =   "MHz"
         Height          =   255
         Left            =   1440
         TabIndex        =   19
         Top             =   600
         Width           =   615
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Channel"
      Height          =   855
      Left            =   5160
      TabIndex        =   15
      Top             =   0
      Width           =   2295
      Begin VB.TextBox Text2 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   240
         TabIndex        =   1
         Text            =   "Text2"
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Standard"
      Height          =   855
      Left            =   360
      TabIndex        =   14
      Top             =   0
      Width           =   4695
      Begin VB.Label Label3 
         Caption         =   "IEEE Std 802.11a"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1440
         TabIndex        =   32
         Top             =   360
         Width           =   2175
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Const maxFpoint As Integer = 501            'ő|Cgl
Const minFpoint As Integer = 1              'ŏ|Cgl
Const maxLpoint As Integer = 14592          'c\ő|Cgl
Const minLpoint As Integer = 1792           'c\ŏ|Cgl
Const Foffset1 As Double = 9000000#
Const Foffset2 As Double = 11000000#
Const Foffset3 As Double = 20000000#
Const Foffset4 As Double = 30000000#
Const dBdiv As Integer = 10
Dim spec(1001) As Double
Dim trc(1001) As String

Sub Command1_Click()

init_FUS
MeasSM

End Sub

Sub init_FUS()
Dim pointF As Double
Dim pointL As Double
Dim i As Integer


Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec

'*** Fus Parameter settings ***
ibwrt ud, "IP"                                  'Preset
ibwrt ud, "TS"                                  'One Sweep
ibwrt ud, "TPS"                                 'Trace points: 501 points
ibwrt ud, "CF " & Format(TxtCF.Text) & "MZ"     'Center frequency
ibwrt ud, "SP " & Format(TxtSP.Text) & "MZ"     'frequency span
ibwrt ud, "RL " & Format(TxtRL.Text) & "DB"     'Reference level
ibwrt ud, "AT " & Format(CmbATT.Text) & "DB"    'Input attenuator
ibwrt ud, "RB " & Format(TxtRB.Text) & "KZ"     'Resolution Bandwidth
ibwrt ud, "VB " & Format(TxtVB.Text) & "KZ"     'Video Bandwidth
ibwrt ud, "SW 500MS"                            'Sweep Time for 11a

Select Case CmbDET.Text                         'Detector
    Case "Posi"
        ibwrt ud, "DET POS"
    Case "Normal"
        ibwrt ud, "DET NRM"
    Case "Sample"
        ibwrt ud, "DET SMP"
    Case "Average"
        ibwrt ud, "DET AVG"
End Select

pointF = Val(TxtSP.Text) / (maxFpoint - minFpoint)   'MHz/point
pointL = 100 / (maxLpoint - minLpoint)               'dB/point


'**********Calcurate specification*************
For i = 0 To (maxFpoint - minFpoint)
    
    If Abs((i - (maxFpoint + minFpoint) / 2) * pointF * 1000000) >= Foffset4 Then
        spec(i) = -40
    ElseIf Abs((i - (maxFpoint + minFpoint) / 2) * pointF * 1000000) < Foffset4 And Abs((i - (maxFpoint + minFpoint) / 2) * pointF * 1000000) >= Foffset3 Then
        spec(i) = -12 * Abs((i - (maxFpoint + minFpoint) / 2) * pointF) / 10 - 4
    ElseIf Abs((i - (maxFpoint + minFpoint) / 2) * pointF * 1000000) < Foffset3 And Abs((i - (maxFpoint + minFpoint) / 2) * pointF * 1000000) >= Foffset2 Then
        spec(i) = -8 * Abs((i - (maxFpoint + minFpoint) / 2) * pointF) / 9 - 92 / 9
    ElseIf Abs((i - (maxFpoint + minFpoint) / 2) * pointF * 1000000) < Foffset2 And Abs((i - (maxFpoint + minFpoint) / 2) * pointF * 1000000) >= Foffset1 Then
        spec(i) = -10 * Abs((i - (maxFpoint + minFpoint) / 2) * pointF) + 90
    Else
        spec(i) = 0#
    End If

    'Text4.SelText = spec(i) & vbCrLf

Next
    
End Sub



Sub MeasSM()
Dim Powerbuf As String * 50
Dim Refbuf As String * 50
Dim jRslt As String
Dim ref As String, trc(1001) As String
Dim Lvl(1001) As Double, margine(1001) As Double
Dim tr(1001) As Integer
Dim Rslt As Integer, tmp As Integer, i As Integer, k As Integer

Text4.SelText = vbCrLf & "Transmit Spectrum Mask check" & "  " & Date & "  " & Time & vbCrLf
Text4.SelText = vbCrLf & "X point,  Y point,  Level,  Spec,  Margine,  Judge" & vbCrLf
' 1. Parameter setting

ibwrt ud, "PWCHON"                              'Channel Power On
   
    Select Case CmbTRC.Text
        Case "Write"
            ibwrt ud, "TS"
        Case "Max Hold"
            ibwrt ud, "CALCA MAX"
            For k = 1 To Val(TxtAVT.Text)
                ibwrt ud, "TS"
            Next
        Case "Average"
            ibwrt ud, "CALCA AVG"
            ibwrt ud, "AG " + TxtAVT.Text           'Max sweep count
            ibwrt ud, "AGC"                         'Average contiune
            ibwrt ud, "AGSGL"                       'Average Once
            ibwrt ud, "AAVG ON"
            ibwrt ud, "CONTS"
            WaitAvgEnd
            'ibwrt ud, "AAVG OFF"
    End Select
    
    Powerbuf = ""
    Refbuf = ""

    If Option1.value = True Then
    
        ibwrt ud, "PS"
        ibwrt ud, "ML?"
        ibrd ud, Powerbuf                           ' Peak Power
    
    Else
    
        ibwrt ud, "PWCH?"
        ibrd ud, Powerbuf                           ' Channel Power
    
    End If
    
    ibwrt ud, "RL?"                                 ' SPA Ref.L
    ibrd ud, Refbuf
    

    '**************Read trace binary data**********************
    ibconfig ud, 19, 0               ' Set EOI
    ibwrt ud, "DLIM2"                ' Set EOI @U3751
    ibwrt ud, "TBA?"                 ' Set BIN mode
    ibrdi ud, tr(), 1001 * 2         ' Read BIN data 1001(501) points
    For i = 0 To (maxFpoint - minFpoint) Step 1
        tmp = tr(i)
        Rslt = (tmp And &HFF&) * 256
        Rslt = Rslt + ((tmp And &HFF00&) / 256)
        trc(i) = Str(Rslt)                         ' to Buffer 1001points
        Lvl(i) = Val(Refbuf) + ((Val(trc(i)) - maxLpoint) * dBdiv * 10 / (maxLpoint - minLpoint))
        margine(i) = Val(Powerbuf) + spec(i) - Lvl(i)
    Next i
    ibwrt ud, "DLIM0"                 'Reset EOI @U3751
    ibconfig ud, 19, 1                'Reset EOI
   
    
    For i = 0 To (maxFpoint - minFpoint)
    
        If margine(i) >= 0 Then
            jRslt = "OK"
        Else
            jRslt = "NG"
        End If
        
        
        Text4.SelText = Str(i + 1) & ":       " & trc(i) & ",   " & Format(Lvl(i), "#00.00") & ",   " & Format(Val(Powerbuf) + spec(i), "#00.00") & ",   " & Format(margine(i), "#00.00") & ",   " & jRslt & vbCrLf
        'ibwrt ud, "CALCA WRITE"
    Next


'ibwrt ud, "PFC OFF"
'ibwrt ud, "LMTA OFF"
ibwrt ud, "PWCHOFF"
ibwrt ud, "MO"
ibwrt ud, "CALCA WRITE"
ibwrt ud, "TPL"                     'Trace points: 1001 points
ibwrt ud, "CONTS"

'  Call ibwrt(ud, "RO OFF")         'Offset level Off

Call ibonl(ud, 0)                   'GPIB device 
Call ibonl(0, 0)                    'GPIB board 
End Sub

Private Sub Form_Load()
    
    'form initial setting
    Text2.Text = "1"
    TxtCF.Text = "5005"
    TxtSP.Text = "80"
    TxtRL.Text = "10"
    TxtRB.Text = "100"
    TxtVB.Text = "30"
    TxtAVT.Text = "3"
    Text4.Text = ""
    
    CmbATT.AddItem "0"
    CmbATT.AddItem "10"
    CmbATT.AddItem "20"
    CmbATT.AddItem "30"
    CmbATT.AddItem "40"
    CmbATT.AddItem "50"
    CmbATT.Text = "30"
    
    CmbDET.AddItem "Normal"
    CmbDET.AddItem "Posi"
    'CmbDET.AddItem "Nega"
    CmbDET.AddItem "Sample"
    CmbDET.AddItem "Average"
    CmbDET.Text = "Posi"
    
    CmbTRC.AddItem "Write"
    'CmbTRC.AddItem "Min Hold"
    CmbTRC.AddItem "Max Hold"
    CmbTRC.AddItem "Average"
    'CmbTRC.AddItem "Power Avg"
    CmbTRC.Text = "Write"
    
    
    
End Sub

Private Sub Text2_Change()
    
    TxtCF.Text = Str(5000 + Val(Text2.Text) * 5)

End Sub

Private Sub TxtCF_KeyPress(KeyAscii As Integer)

    If KeyAscii = 13 Then
    
        Text2.Text = Str((Val(TxtCF.Text) - 5000) / 5)

    End If
    
End Sub
